package jamezo97.clonecraft.recipe;

import jamezo97.clonecraft.CloneCraft;
import jamezo97.clonecraft.dna.ItemData;

import java.util.ArrayList;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class RecipeMutateSerum implements IRecipe, IOnCrafted{
	
	public RecipeMutateSerum(){
		CloneCraftCraftingHandler.add(this);
	}

	@Override
	public void onCrafted(EntityPlayer player, ItemStack result, IInventory ic) {
		ItemStack[] items = getItems(ic);
		if(items != null){
			for(int a = 1; a < items.length; a++){
				ItemStack copy = items[a].copy();
				copy.setItemDamage(0);
				copy.stackSize = 1;
				new ItemData(items[a]).drain().setContaminated().save(copy);
				if(!player.inventory.addItemStackToInventory(copy)){
					player.dropPlayerItem(copy);
				}
			}
		}
	}

	@Override
	public boolean isValidItem(ItemStack stack, IInventory craftMatrix) {
		return getResult(craftMatrix) != null;
	}

	@Override
	public boolean matches(InventoryCrafting ic, World world) {
		return getItems(ic) != null;
	}

	@Override
	public ItemStack getCraftingResult(InventoryCrafting ic) {
		return getResult(ic);
	}
	
	public ItemStack getResult(IInventory ic){
		ItemStack[] items = getItems(ic);
		if(items != null){
			ItemStack result = items[0].copy();
			result.stackSize = 1;
			result.setItemDamage(3);
			ItemData resultData = new ItemData(result);
			for(int a = 2; a < items.length; a++){
				ItemData data = new ItemData(items[a]);
				for(int b = 0; b < data.genes.length; b++){
					resultData.setGene(data.genes[b]);
				}
			}
			resultData.save();
			return result;
		}
		return null;
	}

	public ItemStack[] getItems(IInventory ic){
		ItemStack needle = null;
		ItemStack mutating = null;
		ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
		for(int a = 0; a < ic.getSizeInventory(); a++){
			ItemStack slot = ic.getStackInSlot(a);
			if(slot != null){
				if(slot.itemID == CloneCraft.needle.itemID && slot.getItemDamage() == 0 && !new ItemData(slot).isContaminated()){
					if(needle == null){
						needle = slot;
					}else{
						return null;
					}
				}else if(slot.itemID == CloneCraft.testTube.itemID){
					if(slot.getItemDamage() == 4){
						if(mutating == null){
							mutating = slot;
						}else{
							return null;
						}
					}else if(slot.getItemDamage() == 3 && new ItemData(slot).containsGenes()){
						stacks.add(slot);
					}
				}else{
					return null;
				}
			}
		}


		if(needle == null || mutating == null || stacks.isEmpty()){
			return null;
		}else{
			ItemStack[] stacksRet = new ItemStack[stacks.size() + 2];
			stacksRet[0] = needle;
			stacksRet[1] = mutating;
			for(int a = 0; a < stacks.size(); a++){
				stacksRet[2+a] = stacks.get(a);
			}
			return stacksRet;
		}
	}

	@Override
	public int getRecipeSize() {
		return 0;
	}

	@Override
	public ItemStack getRecipeOutput() {
		return null;
	}

}
